clear all
set more off
cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\"

use wf_step1011.dta, clear

*** Population weights
egen sum_age_total = sum(age_total) if smpl2==1, by(year country)
gen pop_wgt =  age_total/sum_age_total

keep if smpl2==1

cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\figures"

gen share_age_25_54=100-share_age_0_24-share_age_55plus

foreach var in year_school ///		
			share_emp_primary_sector share_emp_secondary_sector share_emp_tertiary_sector ///
			ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp mlog_road_density  ///
			share_age_25_54 ///
			{
			if "`var'"=="year_school" {
				local str0="Years of schooling"
				local str1A=" "
				local str1B=" "
				local str1C=" "	
				
			}
			if "`var'"=="share_emp_primary_sector" {
				local str0="Empl. share in primary sector"
				local str1A=" "
				local str1B=" "
				local str1C=" "				
			}
			if "`var'"=="share_emp_secondary_sector" {
				local str0="Empl. share in secondary sector"
				local str1A=" "
				local str1B=" "
				local str1C=" "					
			}
			if "`var'"=="share_emp_tertiary_sector" {
				local str0="Empl. share in tertiary sector"
				local str1A=" "
				local str1B=" "
				local str1C=" "					
			}
			if "`var'"=="ic_EMP_share_female" {
				local str0="Share of females in employment"
				local str1A=" "
				local str1B=" "
				local str1C=" "	
				
			}
			if "`var'"=="hh_size" {
				local str0="Household size"
				local str1A=" "
				local str1B=" "
				local str1C=" "				
			}
			if "`var'"=="home_own_rate" {
				local str0="Home ownership"
				local str1A=" "
				local str1B=" "
				local str1C=" "					
			}
			if "`var'"=="netmig_rate" {
				local str0="Net migration rate"
				local str1A=" "
				local str1B=" "
				local str1C=" "					
			}

			if "`var'"=="urban_share_500_y1990" {
				local str0="Share of urban population"
				local str1A=" "
				local str1B=" "
				local str1C=" "	
				
			}
			if "`var'"=="logY_ppp" {
				* local str0="Log GDP per capita, x100, PPP"
				local str0="Log GDP p.c. x100, PPP"
				local str1A=" "
				local str1B=" "
				local str1C=" "				
			}
			if "`var'"=="mlog_road_density" {
				local str0="Log road density"
				local str1A=" "
				local str1B=" "
				local str1C=" "					
			}
			
			if "`var'"=="share_age_25_54" {
				local str0="share_age_25_54"
				local str1A=" "
				local str1B=" "
				local str1C=" "					
			}			
			
			twoway ///
				(scatter ue2_hyst `var' if country=="US", msymbol(o) mcolor(black) mfcolor(black)) ///
				(scatter ue2_hyst `var' if country=="UK", msymbol(o) mcolor(red) mfcolor(red)) ///
				(scatter ue2_hyst `var' if country=="CA", msymbol(o) mcolor(blue) mfcolor(blue)) ///
				(scatter ue2_hyst `var' if country=="DE", msymbol(+) mcolor(blue) mfcolor(none)) ///
				(scatter ue2_hyst `var' if country=="AT", msymbol(+) mcolor(red) mfcolor(none)) ///
				(scatter ue2_hyst `var' if country=="CH", msymbol(+) mcolor(black) mfcolor(none)) ///
				(scatter ue2_hyst `var' if country=="BE", msymbol(+) mcolor(green) mfcolor(none)) ///
				(scatter ue2_hyst `var' if country=="NL", msymbol(+) mcolor(pink) mfcolor(none)) ///		
				(scatter ue2_hyst `var' if country=="FR", msymbol(Oh) mcolor(red) mfcolor(none)) ///
				(scatter ue2_hyst `var' if country=="IT", msymbol(Sh) mcolor(black) mfcolor(none)) ///
				(scatter ue2_hyst `var' if country=="ES", msymbol(Oh) mcolor(blue) mfcolor(none)) ///
				(scatter ue2_hyst `var' if country=="SE", msymbol(Th) mcolor(black) mfcolor(none)) ///
				(scatter ue2_hyst `var' if country=="FI", msymbol(Th) mcolor(red) mfcolor(none)) ///
				(scatter ue2_hyst `var' if country=="DK", msymbol(Th) mcolor(blue) mfcolor(none)) ///
				, legend(off) ///
				 xtitle("`str0'") ytitle("Hysteresis (RAW)")	///
				 title("") ///
				 saving(raw_`var'.gph, replace)
				 
				 
			
			reg ue2_hyst cid_* [aw=pop_wgt] if smpl2==1
			capture drop resFE_ue2_hyst
			predict resFE_ue2_hyst if e(sample), resid
			
			reg `var' cid_* [aw=pop_wgt] if smpl2==1
			capture drop resFE_`var'
			predict resFE_`var' if e(sample), resid
			
			
			
			twoway ///
				(scatter resFE_ue2_hyst resFE_`var' if country=="US", msymbol(o) mcolor(black) mfcolor(black)) ///
				(scatter resFE_ue2_hyst resFE_`var' if country=="UK", msymbol(o) mcolor(red) mfcolor(red)) ///
				(scatter resFE_ue2_hyst resFE_`var' if country=="CA", msymbol(o) mcolor(blue) mfcolor(blue)) ///
				(scatter resFE_ue2_hyst resFE_`var' if country=="DE", msymbol(+) mcolor(blue) mfcolor(none)) ///
				(scatter resFE_ue2_hyst resFE_`var' if country=="AT", msymbol(+) mcolor(red) mfcolor(none)) ///
				(scatter resFE_ue2_hyst resFE_`var' if country=="CH", msymbol(+) mcolor(black) mfcolor(none)) ///
				(scatter resFE_ue2_hyst resFE_`var' if country=="BE", msymbol(+) mcolor(green) mfcolor(none)) ///
				(scatter resFE_ue2_hyst resFE_`var' if country=="NL", msymbol(+) mcolor(pink) mfcolor(none)) ///		
				(scatter resFE_ue2_hyst resFE_`var' if country=="FR", msymbol(Oh) mcolor(red) mfcolor(none)) ///
				(scatter resFE_ue2_hyst resFE_`var' if country=="IT", msymbol(Sh) mcolor(black) mfcolor(none)) ///
				(scatter resFE_ue2_hyst resFE_`var' if country=="ES", msymbol(Oh) mcolor(blue) mfcolor(none)) ///
				(scatter resFE_ue2_hyst resFE_`var' if country=="SE", msymbol(Th) mcolor(black) mfcolor(none)) ///
				(scatter resFE_ue2_hyst resFE_`var' if country=="FI", msymbol(Th) mcolor(red) mfcolor(none)) ///
				(scatter resFE_ue2_hyst resFE_`var' if country=="DK", msymbol(Th) mcolor(blue) mfcolor(none)) ///
				, legend(off) ///
				 xtitle("`str0'") ytitle("Hysteresis (RE)")	///
				 title("") ///
				 saving(residFE_`var'.gph, replace)
				 
				 /*
				 legend(label(1 US) label(2 UK) label(3 CA) ///
						 label(4 DE) label(5 AT) label(6 CH) label(7 BE) label(8 NL) ///
						 label(9 FR) label(10 IT) label(11 ES) ///
						 label(12 SE) label(13 FI) label(14 DK) ///
						 rows(1) symysize(2)) ///
				*/
				
				
			
			}
			
			
			
*==================================================================================
*						Legend figure
*==================================================================================
twoway ///
		(scatter resFE_ue2_hyst resFE_ue2_hyst if country=="US" & year==0, msymbol(o) mcolor(black) mfcolor(black)) ///
		(scatter resFE_ue2_hyst resFE_ue2_hyst if country=="UK" & year==0, msymbol(o) mcolor(red) mfcolor(red)) ///
		(scatter resFE_ue2_hyst resFE_ue2_hyst if country=="CA" & year==0, msymbol(o) mcolor(blue) mfcolor(blue)) ///
		(scatter resFE_ue2_hyst resFE_ue2_hyst if country=="DE" & year==0, msymbol(+) mcolor(blue) mfcolor(none)) ///
		(scatter resFE_ue2_hyst resFE_ue2_hyst if country=="AT" & year==0, msymbol(+) mcolor(red) mfcolor(none)) ///
		(scatter resFE_ue2_hyst resFE_ue2_hyst if country=="CH" & year==0, msymbol(+) mcolor(black) mfcolor(none)) ///
		(scatter resFE_ue2_hyst resFE_ue2_hyst if country=="BE" & year==0, msymbol(+) mcolor(green) mfcolor(none)) ///
		(scatter resFE_ue2_hyst resFE_ue2_hyst if country=="NL" & year==0, msymbol(+) mcolor(pink) mfcolor(none)) ///		
		(scatter resFE_ue2_hyst resFE_ue2_hyst if country=="FR" & year==0, msymbol(Oh) mcolor(red) mfcolor(none)) ///
		(scatter resFE_ue2_hyst resFE_ue2_hyst if country=="IT" & year==0, msymbol(Sh) mcolor(black) mfcolor(none)) ///
		(scatter resFE_ue2_hyst resFE_ue2_hyst if country=="ES" & year==0, msymbol(Oh) mcolor(blue) mfcolor(none)) ///
		(scatter resFE_ue2_hyst resFE_ue2_hyst if country=="SE" & year==0, msymbol(Th) mcolor(black) mfcolor(none)) ///
		(scatter resFE_ue2_hyst resFE_ue2_hyst if country=="FI" & year==0, msymbol(Th) mcolor(red) mfcolor(none)) ///
		(scatter resFE_ue2_hyst resFE_ue2_hyst if country=="DK" & year==0, msymbol(Th) mcolor(blue) mfcolor(none)) ///
					, xtitle(" ") title(" ") ytitle("") ///
					legend(ring(0) pos(0)) yscale(off) xscale(off) ///
					plotregion( ifcolor(none) fcolor(none) lcolor(none)  ilcolor(none) ) graphregion( ifcolor(none) fcolor(none)  lcolor(none)  ilcolor(none) ) ///
					legend(label(1 US) label(2 UK) label(3 CA) ///
						 label(4 DE) label(5 AT) label(6 CH) label(7 BE) label(8 NL) ///
						 label(9 FR) label(10 IT) label(11 ES) ///
						 label(12 SE) label(13 FI) label(14 DK) ///
						 rows(5) ) ///
					saving(f_dummy.gph, replace)			

					
*==================================================================================
*						Combine figures
*==================================================================================		

graph combine 	raw_year_school.gph  raw_logY_ppp.gph raw_ic_EMP_share_female.gph raw_netmig_rate.gph ///
				raw_share_emp_primary_sector.gph raw_share_emp_secondary_sector.gph raw_share_emp_tertiary_sector.gph raw_mlog_road_density.gph   ///
				raw_hh_size.gph raw_home_own_rate.gph raw_urban_share_500_y1990.gph  f_dummy.gph ///
				, imargin(tiny) rows(3)
				
